-- ========================================================================
-- Copyright (C) 2022      OpenDSI              <support@open-dsi.fr>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see https://www.gnu.org/licenses/.
-- ========================================================================.
--
-- Table to store depreciation of a fixed asset
--
-- Data example:
-- INSERT INTO llx_asset_depreciation (rowid, fk_asset, depreciation_mode, ref, depreciation_date, depreciation_ht, cumulative_depreciation_ht, accountancy_code_debit, accountancy_code_credit, tms, fk_user_modif) VALUES
-- (194, 1, 'economic', '2022-01', '2022-01-31 23:59:59', 2.00000000, 2.00000000, '2818', '68112', '2022-03-09 14:10:29', NULL),
-- (195, 1, 'economic', '2022-02', '2022-02-28 23:59:59', 5.00000000, 7.00000000, '2818', '68112', '2022-03-09 14:10:29', NULL),
-- (314, 1, 'economic', '2022-03', '2022-03-31 23:59:59', 8.33000000, 15.33000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (315, 1, 'economic', '2022-04', '2022-04-30 23:59:59', 8.33000000, 23.66000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (316, 1, 'economic', '2022-05', '2022-05-31 23:59:59', 8.33000000, 31.99000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (317, 1, 'economic', '2022-06', '2022-06-30 23:59:59', 8.33000000, 40.32000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (318, 1, 'economic', '2022-07', '2022-07-31 23:59:59', 8.33000000, 48.65000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (319, 1, 'economic', '2022-08', '2022-08-31 23:59:59', 8.33000000, 56.98000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (320, 1, 'economic', '2022-09', '2022-09-30 23:59:59', 8.33000000, 65.31000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (321, 1, 'economic', '2022-10', '2022-10-31 23:59:59', 8.33000000, 73.64000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (322, 1, 'economic', '2022-11', '2022-11-30 23:59:59', 8.33000000, 81.97000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (323, 1, 'economic', '2022-12', '2022-12-31 23:59:59', 8.33000000, 90.30000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (324, 1, 'economic', '2023-01', '2023-01-31 23:59:59', 8.33000000, 98.63000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (325, 1, 'economic', '2023-02', '2023-02-28 23:59:59', 8.33000000, 106.96000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (326, 1, 'economic', '2023-03', '2023-03-31 23:59:59', 8.33000000, 115.29000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (327, 1, 'economic', '2023-04', '2023-04-30 23:59:59', 8.33000000, 123.62000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (328, 1, 'economic', '2023-05', '2023-05-31 23:59:59', 8.33000000, 131.95000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (329, 1, 'economic', '2023-06', '2023-06-30 23:59:59', 8.33000000, 140.28000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (330, 1, 'economic', '2023-07', '2023-07-31 23:59:59', 8.33000000, 148.61000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (331, 1, 'economic', '2023-08', '2023-08-31 23:59:59', 8.33000000, 156.94000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (332, 1, 'economic', '2023-09', '2023-09-30 23:59:59', 8.33000000, 165.27000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (333, 1, 'economic', '2023-10', '2023-10-31 23:59:59', 8.33000000, 173.60000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (334, 1, 'economic', '2023-11', '2023-11-30 23:59:59', 8.33000000, 181.93000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (335, 1, 'economic', '2023-12', '2023-12-31 23:59:59', 8.33000000, 190.26000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (336, 1, 'economic', '2024-01', '2024-01-31 23:59:59', 8.33000000, 198.59000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (337, 1, 'economic', '2024-02', '2024-02-29 23:59:59', 8.33000000, 206.92000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (338, 1, 'economic', '2024-03', '2024-03-31 23:59:59', 8.33000000, 215.25000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (339, 1, 'economic', '2024-04', '2024-04-30 23:59:59', 8.33000000, 223.58000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (340, 1, 'economic', '2024-05', '2024-05-31 23:59:59', 8.33000000, 231.91000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (341, 1, 'economic', '2024-06', '2024-06-30 23:59:59', 8.33000000, 240.24000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (342, 1, 'economic', '2024-07', '2024-07-31 23:59:59', 8.33000000, 248.57000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (343, 1, 'economic', '2024-08', '2024-08-31 23:59:59', 8.33000000, 256.90000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (344, 1, 'economic', '2024-09', '2024-09-30 23:59:59', 8.33000000, 265.23000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (345, 1, 'economic', '2024-10', '2024-10-31 23:59:59', 8.33000000, 273.56000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (346, 1, 'economic', '2024-11', '2024-11-30 23:59:59', 8.33000000, 281.89000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (347, 1, 'economic', '2024-12', '2024-12-31 23:59:59', 8.33000000, 290.22000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (348, 1, 'economic', '2025-01', '2025-01-31 23:59:59', 8.33000000, 298.55000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (349, 1, 'economic', '2025-02', '2025-02-28 23:59:59', 8.33000000, 306.88000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (350, 1, 'economic', '2025-03', '2025-03-31 23:59:59', 8.33000000, 315.21000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (351, 1, 'economic', '2025-04', '2025-04-30 23:59:59', 8.33000000, 323.54000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (352, 1, 'economic', '2025-05', '2025-05-31 23:59:59', 8.33000000, 331.87000000, '2818', '68112', '2022-03-09 14:15:48', NULL),
-- (353, 1, 'economic', '2025-06', '2025-06-30 23:59:59', 8.33000000, 340.20000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (354, 1, 'economic', '2025-07', '2025-07-31 23:59:59', 8.33000000, 348.53000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (355, 1, 'economic', '2025-08', '2025-08-31 23:59:59', 8.33000000, 356.86000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (356, 1, 'economic', '2025-09', '2025-09-30 23:59:59', 8.33000000, 365.19000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (357, 1, 'economic', '2025-10', '2025-10-31 23:59:59', 8.33000000, 373.52000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (358, 1, 'economic', '2025-11', '2025-11-30 23:59:59', 8.33000000, 381.85000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (359, 1, 'economic', '2025-12', '2025-12-31 23:59:59', 8.33000000, 390.18000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (360, 1, 'economic', '2026-01', '2026-01-31 23:59:59', 8.33000000, 398.51000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (361, 1, 'economic', '2026-02', '2026-02-28 23:59:59', 8.33000000, 406.84000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (362, 1, 'economic', '2026-03', '2026-03-31 23:59:59', 8.33000000, 415.17000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (363, 1, 'economic', '2026-04', '2026-04-30 23:59:59', 8.33000000, 423.50000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (364, 1, 'economic', '2026-05', '2026-05-31 23:59:59', 8.33000000, 431.83000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (365, 1, 'economic', '2026-06', '2026-06-30 23:59:59', 8.33000000, 440.16000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (366, 1, 'economic', '2026-07', '2026-07-31 23:59:59', 8.33000000, 448.49000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (367, 1, 'economic', '2026-08', '2026-08-31 23:59:59', 8.33000000, 456.82000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (368, 1, 'economic', '2026-09', '2026-09-30 23:59:59', 8.33000000, 465.15000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (369, 1, 'economic', '2026-10', '2026-10-31 23:59:59', 8.33000000, 473.48000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (370, 1, 'economic', '2026-11', '2026-11-30 23:59:59', 8.33000000, 481.81000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (371, 1, 'economic', '2026-12', '2026-12-31 23:59:59', 8.33000000, 490.14000000, '2818', '68112', '2022-03-09 14:15:49', NULL),
-- (372, 1, 'economic', '2027-01', '2027-01-31 23:59:59', 9.86000000, 500.00000000, '2818', '68112', '2022-03-09 14:15:49', NULL);

CREATE TABLE llx_asset_depreciation(
    rowid                           integer         AUTO_INCREMENT PRIMARY KEY NOT NULL,

    fk_asset                        integer         NOT NULL,
    depreciation_mode               varchar(255)	NOT NULL,	-- (economic, fiscal or other)

    ref                             varchar(255)	NOT NULL,
    depreciation_date               datetime		NOT NULL,
    depreciation_ht                 double(24,8)	NOT NULL,
    cumulative_depreciation_ht      double(24,8)	NOT NULL,

    accountancy_code_debit          varchar(32),
    accountancy_code_credit         varchar(32),

    tms                             timestamp       DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    fk_user_modif                   integer
) ENGINE=innodb;
